
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	


	[TestFixture]
	public class DAL_BloodUnitStatus : BaseTest 
	{
		
		private DataTable _dtStatus;

		private string _baseQuery = string.Concat(	"SELECT TOP 1 * FROM BloodUnitStatus BUS ",
			"JOIN BloodUnitStatusCodeCurrent BUSCC ON BUS.BloodUnitGuid = BUSCC.BloodUnitGuid ",
			"WHERE BUSCC.UnitStatusCode = 'A' ",
			"AND BUS.BloodUnitGuid IN ",
			"(SELECT BloodUnitGuid FROM BloodUnit WHERE RecordStatusCode = 'A' AND DivisionCode = '", 
			UnitTestConfig.TestDivisionCode, 
			"')" );

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtStatus = UnitTestUtil.RunSQLGetDataTable(_baseQuery, true);
				

				this.RefreshData = false;
			}
		}

		
		[Test]
		public void GetEmptyBloodUnitStatusTableSchema_Pass()
		{
			DataTable dtTest = DAL.BloodUnitStatus.GetEmptyBloodUnitStatusTableSchema(true);

			Assert.AreEqual(TABLES.BloodUnitStatus.TableName, dtTest.TableName, "TableName");
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(12, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BloodUnitStatusGuid), TABLES.BloodUnitStatus.BloodUnitStatusGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.RowVersion), TABLES.BloodUnitStatus.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.TestingLimitIndicator), TABLES.BloodUnitStatus.TestingLimitIndicator);
		}

		[Test]
		public void GetEmptyBloodUnitStatusTableSchema_Fail()
		{
			DataTable dtTest = DAL.BloodUnitStatus.GetEmptyBloodUnitStatusTableSchema(false);

			Assert.AreEqual(TABLES.BloodUnitStatus.TableName, dtTest.TableName, "TableName");
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(6, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BloodUnitStatusGuid), TABLES.BloodUnitStatus.BloodUnitStatusGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BloodUnitGuid), TABLES.BloodUnitStatus.BloodUnitGuid);
		}


		[Test]
		public void GetBloodUnitStatusByGuid_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtStatus.Rows[0][TABLES.BloodUnitStatus.BloodUnitGuid];

			DataTable dtTest = DAL.BloodUnitStatus.GetBloodUnitStatusByGuid(unitGuid);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(17, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BloodUnitStatusGuid), TABLES.BloodUnitStatus.BloodUnitStatusGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BloodUnitGuid), TABLES.BloodUnitStatus.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusDate), TABLES.BloodUnitStatus.UnitStatusDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineCannedCommentGuid), TABLES.BloodUnitStatus.QuarantineCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.LastUpdateDate), TABLES.BloodUnitStatus.LastUpdateDate);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.LastUpdateUser), TABLES.BloodUnitStatus.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.EmergencyIssueIndicator), TABLES.BloodUnitStatus.EmergencyIssueIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.RowVersion), TABLES.BloodUnitStatus.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.TestingLimitIndicator), TABLES.BloodUnitStatus.TestingLimitIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.CurrentStatusLastUpdateDate), ARTIFICIAL.CurrentStatusLastUpdateDate);
		}

		[Test]
		public void GetBloodUnitStatusByGuid_Fail()
		{
			DataTable dtTest = DAL.BloodUnitStatus.GetBloodUnitStatusByGuid(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetPreviousBloodUnitStatusByGuid_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtStatus.Rows[0][TABLES.BloodUnitStatus.BloodUnitGuid];

			DataTable dtTest = DAL.BloodUnitStatus.GetPreviousBloodUnitStatusByGuid(unitGuid);
			
			//Not all rows will have previous status, and there's no way to tell
			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(2, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusCode), TABLES.UnitStatus.UnitStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);

		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetPreviousBloodUnitStatusByGuid_Fail()
		{
			DataTable dt = DAL.BloodUnitStatus.GetPreviousBloodUnitStatusByGuid(System.Guid.Empty);
		}

	}
}


#endif



